//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12

import wesual.Ui 1.0

UiIcon {
    id : infoTip_

    property string infoTip
    property int displayWidth : 220

    iconName : "infotip"

    UiInfoTip {
        anchors.fill : parent
        verticalOffset : 12
        flipped : true
        contentDelegate : Item {
            implicitWidth : infoTip_.displayWidth
            implicitHeight : info_.implicitHeight

            Text {
                id : info_

                anchors.fill : parent
                wrapMode : Text.Wrap
                font  : UiFonts.getFont(UiFonts.Regular, 13)
                lineHeight : 1.05
                color : "#848484"
                text : infoTip_.infoTip
            }
        }
    }
}
